	function [f, g] = EX_12_9_fun(x)
	
	%	Cost function used in Example 12.9.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1983-08-15
	%	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	global wTc wTs dc ds Nodd
	f = x(1);
	g = 0;
	
	% Nodd is the order of the odd branch
	alfa_odd = x(3:Nodd+2);	
	alfa_even = x(Nodd+3:length(x));
	
	% Stopband
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wTs);
	H = 0.5*(S2 - S1);
	g1 = abs(H)-ds;
	
	% Passband
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wTc);
	H = 0.5*(S2 - S1);
	g3 = 1-abs(H)-dc;
	
	Ph = unwrap(angle(H));
	g4 = abs(Ph + x(2)*wTc) -x(1);	% Phase error
	
	g = [g1 g3 g4];
	
